<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Auditable as AuditableTrait;

class Gred extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'gred';

    protected $primaryKey = 'no';

    protected $fillable = ['no', 'gred', 'nama', 'aktif'];

    public function tugas()
    {
        return $this->hasMany(Tugasan::class, 'gred', 'no');
    }

    protected static function boot()
    {
        parent::boot();

        // Define an event listener for the creating event
        static::creating(function ($gred) {
            // Modify the 'nama' attribute to uppercase before insertion
            $gred->nama = strtoupper($gred->nama);
        });
    }

    public function getRouteKeyName(): string
    {
        return 'slug'; // Laravel will now use slug for route model binding
    }

}
