<?php

namespace App\Filament\Resources;

use Filament\Schemas\Schema;
use Filament\Forms\Components\TextInput;
use Filament\Actions\EditAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\BulkActionGroup;
use App\Filament\Resources\TugasSampinganResource\Pages\ListTugasSampingans;
use App\Filament\Resources\TugasSampinganResource\Pages\CreateTugasSampingan;
use App\Filament\Resources\TugasSampinganResource\Pages\EditTugasSampingan;
use App\Filament\Resources\TugasSampinganResource\Pages;
use App\Filament\Resources\TugasSampinganResource\RelationManagers;
use App\Models\TugasSampingan;
use Filament\Forms;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Select;

class TugasSampinganResource extends Resource
{
    protected static ?string $model = TugasSampingan::class;

    protected static string | \BackedEnum | null $navigationIcon = 'heroicon-s-document-text';

    protected static ?string $navigationLabel = 'TUGAS SAMPINGAN';

    protected static ?string $pluralModelLabel = 'TUGAS SAMPINGAN';

    protected static string | \UnitEnum | null $navigationGroup = 'UTILITI';

    protected static ?string $slug = 'tugassampingan';


    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('nama')->label('Nama')->rules(['required', 'max:500', 'unique:tugas_sampingan,nama']),
                Select::make('aktif')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options([
                        '1' => 'AKTIF',
                        '0' => 'TIDAK AKTIF',
                    ])
                    ->rules(['required']),
            ]);
    }

    public static function table(Table $table): Table
    {
        $tugasQuery = TugasSampingan::query()->where('aktif', 1);

        return $table
            ->query($tugasQuery)
            ->columns([
                TextColumn::make('index')->label('NO')->rowIndex(),
                TextColumn::make('nama'),
                IconColumn::make('aktif')
                    ->label('STATUS')
                    ->boolean(),
                TextColumn::make('nama')->label('NAMA')->searchable(),
            ])
            ->deferLoading()
            ->striped()
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make()->label(''),
                DeleteAction::make()->label(''),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    //Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListTugasSampingans::route('/'),
            'create' => CreateTugasSampingan::route('/create'),
            'edit' => EditTugasSampingan::route('/{record:slug}/edit'),
        ];
    }

    public static function canViewAny(): bool
    {
        // dd(auth()->user()->roles());
        return auth()
            ->user()
            ->hasAnyRole(['Super Admin', 'Penyelaras']);
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::where('aktif',1)->count();
    }
}
