<?php

namespace App\Filament\Resources;

use Althinect\FilamentSpatieRolesPermissions\Resources\RoleResource as BaseRoleResource;

class RoleResource extends BaseRoleResource
{
    protected static string | \BackedEnum | null $navigationIcon = 'heroicon-o-shield-check';
    protected static ?string $navigationLabel = 'ROLES'; // Uppercase
    protected static string | \UnitEnum | null $navigationGroup = 'SYSTEM'; // Uppercase

    public static function canViewAny(): bool
    {
        return auth()->check() && auth()->user()->hasRole('Super Admin');
    }
}
