<?php

namespace App\Filament\Resources;

use Althinect\FilamentSpatieRolesPermissions\Resources\PermissionResource as BasePermissionResource;

class PermissionResource extends BasePermissionResource
{
    protected static string | \BackedEnum | null $navigationIcon = 'heroicon-o-key';
    protected static ?string $navigationLabel = 'PERMISSIONS'; // Uppercase
    protected static string | \UnitEnum | null $navigationGroup = 'SYSTEM'; // Uppercase

    public static function canViewAny(): bool
    {
        return auth()->check() && auth()->user()->hasRole('Super Admin');
    }
}
