<?php

namespace App\Providers\Filament;

use Filament\Pages\Dashboard;
use Filament\Widgets\AccountWidget;
use App\Filament\Resources\RoleResource;
use App\Filament\Resources\PermissionResource;
use Filament\Navigation\MenuItem;
use Filament\Facades\Filament;
use App\Filament\Helper\LoginMakeUp;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Widgets;
use App\Filament\Widgets\GambarProfilWidget;
use Illuminate\Support\Facades\Auth;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;

use AchyutN\FilamentLogViewer\FilamentLogViewer;
use GeoSot\FilamentEnvEditor\FilamentEnvEditorPlugin;
use Althinect\FilamentSpatieRolesPermissions\FilamentSpatieRolesPermissionsPlugin;

class AdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        $panel = $panel
            ->sidebarCollapsibleOnDesktop()
            ->default()
            ->id('admin')
            ->path('etask')
            ->login(LoginMakeUp::class)
            ->brandName('SISTEM E-TASK')
            ->favicon('/img/etask.png')

            ->colors([
                'primary' => Color::Green,
            ])

            ->discoverResources(in: app_path('Filament/Resources'), for: 'App\\Filament\\Resources')
            ->discoverPages(in: app_path('Filament/Pages'), for: 'App\\Filament\\Pages')
            ->pages([Dashboard::class])
            ->discoverWidgets(in: app_path('Filament/Widgets'), for: 'App\\Filament\\Widgets')
            ->widgets([GambarProfilWidget::class, AccountWidget::class])

            ->middleware([EncryptCookies::class, AddQueuedCookiesToResponse::class, StartSession::class, AuthenticateSession::class, ShareErrorsFromSession::class, VerifyCsrfToken::class, SubstituteBindings::class, DisableBladeIconComponents::class, DispatchServingFilamentEvent::class])

            ->authMiddleware([Authenticate::class])

            ->navigationGroups(['PERIBADI', 'UTILITI', 'TUGASAN', 'DIREKTORI', 'LAPORAN', 'SYSTEM','ROLES AND PERMISSIONS'])

            ->plugins([FilamentLogViewer::make()->authorize(fn() => Auth::check() && Auth::user()->roles()->value('id') == 1)->navigationGroup('SYSTEM')->navigationLabel('LOG VIEWER'), FilamentEnvEditorPlugin::make()->authorize(fn() => Auth::check() && Auth::user()->roles()->value('id') == 1)->navigationGroup('SYSTEM')->navigationLabel('KONFIGURASI')->navigationIcon('heroicon-o-cog-8-tooth')->navigationSort(1)->slug('env-editor'), FilamentSpatieRolesPermissionsPlugin::make(),\Statikbe\FilamentTranslationManager\FilamentChainedTranslationManagerPlugin::make(),])
            ->resources([RoleResource::class, PermissionResource::class]);

        /**
         * ✅ IKUT CONTOH PERTAMA
         * Roles & Permissions hanya didaftarkan untuk Super Admin
         */
        // if (Auth::check() && Auth::user()->hasRole('Super Admin')) {
        //     $panel->plugin(
        //         FilamentSpatieRolesPermissionsPlugin::make()
        //     );
        // }

        return $panel;
    }

    public function boot(): void
    {
        Filament::serving(function () {
            Filament::registerUserMenuItems([
                // This forces the default logout item to be uppercase
                // 'logout' => MenuItem::make()->label('LOG KELUAR'),

                // Your existing menu item
                MenuItem::make()->label('PERIBADI')->url('peribadi')->icon('heroicon-o-home'),
            ]);
        });
    }
}
