<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Auditable as AuditableTrait;

class Tugasan extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'tugas';

    protected $primaryKey = 'no';

    protected $fillable = ['no', 'no_tugas_sampingan', 'no_unit_tugas_sampingan', 'peringkat', 'pemberat', 'no_staf', 'email', 'gred', 'no_institusi_jabatan', 'tarikh_lantikan', 'sesi', 'no_status', 'catatan', 'aktif'];

    protected static function boot()
    {
        parent::boot();

        // Define an event listener for the creating event
        static::creating(function ($tugas) {
            // Modify the 'nama' attribute to uppercase before insertion
            $tugas->catatan = strtoupper($tugas->catatan);
        });

        static::updating(function ($tugas) {
            // Modify the 'nama' attribute to uppercase before insertion
            $tugas->catatan = strtoupper($tugas->catatan);
        });
    }

    public function pengguna()
    {
        return $this->belongsTo(Pengguna::class, 'email', 'email');
    }

    public function tugasSampingan()
    {
        return $this->belongsTo(TugasSampingan::class, 'no_tugas_sampingan', 'no');
    }

    public function unitTugasSampingan()
    {
        return $this->belongsTo(UnitTugasSampingan::class, 'no_unit_tugas_sampingan', 'no');
    }

    public function senaraiPeringkat()
    {
        return $this->belongsTo(Peringkat::class, 'peringkat', 'no');
    }

    public function senaraiSesi()
    {
        return $this->belongsTo(Sesi::class, 'sesi', 'no');
    }

    public function status()
    {
        return $this->belongsTo(Status::class, 'no_status', 'no');
    }

    public function SenaraiGredLama()
    {
        return $this->belongsTo(Gred::class, 'gred', 'no');
    }

    public function institusiJabatan()
    {
        return $this->belongsTo(InstitusiJabatan::class, 'no_institusi_jabatan', 'no');
    }

    public static function senaraiTugasanBaru($institusi, $jabatan, $sesi)
    {
        $senarai_tugasan = Tugasan::where('tugas.aktif', 1)
            ->where('users.aktif', 1)
            ->where('institusi_jabatan.no_institusi', $institusi)
            ->where('tugas.sesi', $sesi)
            ->orderBy('users.nama', 'asc')
            ->leftJoin('institusi_jabatan', 'institusi_jabatan.no', '=', 'tugas.no_institusi_jabatan')
            ->leftJoin('users', 'users.email', '=', 'tugas.email')
            ->leftJoin('jabatan', 'jabatan.no', '=', 'institusi_jabatan.no_jabatan')
            ->leftJoin('tugas_sampingan', 'tugas_sampingan.no', '=', 'tugas.no_tugas_sampingan')
            ->leftJoin('unit_tugas_sampingan', 'unit_tugas_sampingan.no', '=', 'tugas.no_unit_tugas_sampingan')
            ->leftJoin('status', 'status.no', '=', 'tugas.no_status')
            ->leftJoin('peringkat', 'peringkat.no', '=', 'tugas.peringkat')
            ->leftJoin('gred', 'gred.no', '=', 'users.gred')
            ->leftJoin('sesi', 'sesi.no', '=', 'tugas.sesi')
            ->select('users.nama as nama_pengguna', 'jabatan.nama as nama_jabatan', 'tugas_sampingan.nama as nama_tugas_sampingan', 'unit_tugas_sampingan.nama as nama_unit_tugasan_sampingan', 'status.nama as nama_status', 'tugas.aktif as aktif', 'tugas.tarikh_lantikan as tarikh_lantikan', 'tugas.catatan as catatan', 'peringkat.nama as nama_peringkat', 'gred.nama as nama_gred', 'sesi.nama as nama_sesi');

        if (!empty($jabatan)) {
            $senarai_tugasan->where('jabatan.no', $jabatan);
        }

        $senarai_tugasan = $senarai_tugasan->orderBy('users.nama')->get();

        return $senarai_tugasan;
    }

    public function getRouteKeyName(): string
    {
        return 'slug'; // Laravel will now use slug for route model binding
    }

}
