<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Auditable as AuditableTrait;

class Status extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'status';

    protected $primaryKey = 'no';

    protected $fillable = ['no', 'nama', 'aktif'];

    protected static function boot()
    {
        parent::boot();

        // Define an event listener for the creating event
        static::creating(function ($status) {
            // Modify the 'nama' attribute to uppercase before insertion
            $status->nama = strtoupper($status->nama);
        });
    }

    public function getRouteKeyName(): string
    {
        return 'slug'; // Laravel will now use slug for route model binding
    }

}
