<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Auditable as AuditableTrait;

class Sesi extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'sesi';

    protected $primaryKey = 'no';

    protected $fillable = ['no', 'sesi_mula', 'sesi_tamat', 'semester', 'nama', 'aktif'];

    protected static function boot()
    {
        parent::boot();

        // Define an event listener for the creating event
        static::creating(function ($sesi) {
            // Modify the 'nama' attribute to uppercase before insertion
            $sesi->nama = strtoupper($sesi->nama);
        });
    }

    public function dokumenRujukan()
    {
        return $this->hasMany(DokumenRujukan::class, 'no_sesi', 'no');
    }

    public function tugas()
    {
        return $this->hasMany(Tugasan::class, 'sesi', 'no');
    }

    public function getRouteKeyName(): string
    {
        return 'slug'; // Laravel will now use slug for route model binding
    }

}
