<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Auditable as AuditableTrait;

class InstitusiJabatan extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'institusi_jabatan';

    protected $primaryKey = 'no';

    protected $fillable = ['no', 'no_institusi', 'no_jabatan', 'unit_tugas_sampingan', 'aktif'];

    protected static function boot()
    {
        parent::boot();

        // Define an event listener for the creating event
        static::creating(function ($institusi_jabatan) {
            // Modify the 'nama' attribute to uppercase before insertion
            $institusi_jabatan->nama = strtoupper($institusi_jabatan->nama);
        });
    }

    public function institusi()
    {
        return $this->belongsTo(Institusi::class, 'no_institusi', 'no');
    }

    public function jabatan()
    {
        return $this->belongsTo(Jabatan::class, 'no_jabatan', 'no');
    }

    public function getRouteKeyName(): string
    {
        return 'slug'; // Laravel will now use slug for route model binding
    }

}
