<?php

namespace App\Filament\Resources;

use Filament\Schemas\Schema;
use Filament\Forms\Components\TextInput;
use Filament\Actions\EditAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\BulkActionGroup;
use App\Filament\Resources\UnitTugasSampinganResource\Pages\ListUnitTugasSampingans;
use App\Filament\Resources\UnitTugasSampinganResource\Pages\CreateUnitTugasSampingan;
use App\Filament\Resources\UnitTugasSampinganResource\Pages\EditUnitTugasSampingan;
use App\Filament\Resources\UnitTugasSampinganResource\Pages;
use App\Filament\Resources\UnitTugasSampinganResource\RelationManagers;
use App\Models\UnitTugasSampingan;
use Filament\Forms;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Select;


class UnitTugasSampinganResource extends Resource
{
    protected static ?string $model = UnitTugasSampingan::class;

    protected static string | \BackedEnum | null $navigationIcon = 'heroicon-s-document-text';

    protected static ?string $navigationLabel = 'UNIT TUGAS SAMPINGAN';

    protected static ?string $pluralModelLabel = 'UNIT TUGAS SAMPINGAN';

    protected static string | \UnitEnum | null $navigationGroup = 'UTILITI';

    protected static ?string $slug = 'unittugassampingan';

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('nama')->label('Nama')->rules(['required', 'max:100', 'unique:unit_tugas_sampingan,nama']),
                Select::make('aktif')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options([
                        '1' => 'AKTIF',
                        '0' => 'TIDAK AKTIF',
                    ])
                    ->rules(['required']),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('nama'),
                IconColumn::make('aktif')
                    ->label('STATUS')
                    ->boolean(),
                TextColumn::make('nama')->label('NAMA')->searchable(isIndividual: true, isGlobal: false),
            ])
            ->deferLoading()
            ->striped()
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make()->label(''),
                DeleteAction::make()->label(''),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    //Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListUnitTugasSampingans::route('/'),
            'create' => CreateUnitTugasSampingan::route('/create'),
            'edit' => EditUnitTugasSampingan::route('/{record:slug}/edit'),
        ];
    }

    public static function canViewAny(): bool
    {
        $userId = auth()->user()->jenis_pengguna;
        return in_array($userId, [1]);
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }
}
