<?php

namespace App\Filament\Resources;

use Filament\Schemas\Schema;
use Filament\Actions\Action;
use Filament\Actions\BulkActionGroup;
use App\Filament\Resources\ManualPenggunaResource\Pages\ListManualPenggunas;
use App\Filament\Resources\ManualPenggunaResource\Pages;
use App\Filament\Resources\ManualPenggunaResource\RelationManagers;
use App\Models\JenisLaporan;
use Filament\Forms;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Support\Enums\IconPosition;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Facades\Auth;

class ManualPenggunaResource extends Resource
{
    protected static ?string $model = JenisLaporan::class;

    protected static string | \BackedEnum | null $navigationIcon = 'heroicon-s-document-text';

    protected static ?string $navigationLabel = 'MANUAL PENGGUNA';

    protected static ?string $pluralModelLabel = 'MANUAL PENGGUNA';

    protected static string | \UnitEnum | null $navigationGroup = 'LAPORAN';

    protected static ?string $slug = 'manualpengguna';

    public static function form(Schema $schema): Schema
    {
        return $schema->components([
            //
        ]);
    }

    public static function table(Table $table): Table
    {
        $jenis_pengguna = auth()->user()->roles()->value('id');
        // dd($jenis_pengguna);
        $email = Auth::user()->email;
        $no_institusi_jabatan = Auth::user()->no_institusi_jabatan;

        $tugasQuery = JenisLaporan::query()->with(['jenisdokumen']);

        if ($jenis_pengguna == 1) {
            // If user is not admin, filter jenis laporan based on user's role
        } elseif ($jenis_pengguna == 2) {
            $tugasQuery->whereIn('no', [6, 7]);
        } elseif ($jenis_pengguna == 3) {
            $tugasQuery->whereIn('no', [6]);
        }

        return $table
            ->query($tugasQuery)
            ->columns([TextColumn::make('nama')->label('NAMA'), TextColumn::make('jenisdokumen.nama')->label('DOKUMEN')])
            ->deferLoading()
            ->filters([
                //
            ])
            ->recordActions([
                Action::make('download')
                    ->label('MUAT TURUN')
                    ->icon('heroicon-o-arrow-down-tray')
                    ->iconPosition(IconPosition::Before)
                    ->url(function ($record) {
                        // Tetapkan fail berdasarkan ID
                        if ($record->no == 6) {
                            return asset('manual/MANUAL PENGGUNA E-TASK.pdf');
                        } elseif ($record->no == 7) {
                            return asset('manual/MANUAL PENYELARAS E-TASK.pdf');
                        } else {
                            return '#'; // fallback, atau boleh kosongkan
                        }
                    })
                    ->openUrlInNewTab(), // Optional: open in new tab
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    // Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
                //
            ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListManualPenggunas::route('/'),
            // 'create' => Pages\CreateManualPengguna::route('/create'),
            // 'edit' => Pages\EditManualPengguna::route('/{record}/edit'),
        ];
    }

    public static function canCreate(): bool
    {
        return false;
    }

    public static function canViewAny(): bool
    {
        // dd(auth()->user()->roles());
        return auth()
            ->user()
            ->hasAnyRole(['Super Admin', 'Penyelaras', 'Pengguna', 'Pengurusan']);
    }
}
