<?php

namespace App\Filament\Resources;

use Filament\Schemas\Schema;
use App\Filament\Resources\MaklumatTugasSampinganResource\Pages\ListMaklumatTugasSampingans;
use App\Filament\Resources\MaklumatTugasSampinganResource\Pages;
use App\Filament\Resources\MaklumatTugasSampinganResource\RelationManagers;
use App\Models\Tugasan;
use Filament\Forms;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Support\Facades\Hash;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Columns\IconColumn;
use Filament\Forms\Components\FileUpload;
use Filament\Tables\Columns\ImageColumn;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Textarea;
use Filament\Tables\Filters\SelectFilter;
use Illuminate\Contracts\Pagination\Paginator;
use Illuminate\Support\Facades\Auth;

use App\Models\Pengguna;
use App\Models\Gred;
use App\Models\JenisPengguna;
use App\Models\InstitusiJabatan;
use App\Models\Jabatan;
use App\Models\Institusi;
use App\Models\Peringkat;
use App\Models\Sesi;
use App\Models\Status;
use App\Models\TugasSampingan;
use App\Models\UnitTugasSampingan;


class MaklumatTugasSampinganResource extends Resource
{
    protected static ?string $model = Tugasan::class;

    protected static string | \BackedEnum | null $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $pluralModelLabel = 'DIREKTORI TUGAS';

    protected static ?string $navigationLabel = 'DIREKTORI TUGAS';

    protected static string | \UnitEnum | null $navigationGroup = 'DIREKTORI';

    protected static ?string $slug = 'maklumattugassampingan';

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        $jenis_pengguna = auth()->user()->roles()->value('id');
        $email = Auth::user()->email;
        $no_institusi_jabatan = Auth::user()->no_institusi_jabatan;

        // Adjust the query based on the user's role
        $tugasQuery = Tugasan::query()->where('aktif', 1)
            ->with(['pengguna', 'tugasSampingan', 'unitTugasSampingan', 'senaraiPeringkat', 'senaraisesi', 'status','SenaraiGredLama']);
        if ($jenis_pengguna == 2 || $jenis_pengguna == 3 || $jenis_pengguna == 4) {
            // If user is of type 4, exclude specific jenis laporan
            $institusi_jabatan = InstitusiJabatan::where('no', $no_institusi_jabatan)->first();
            $institusi = $institusi_jabatan->no_institusi;

            $tugasQuery->whereHas('institusiJabatan', function ($query) use ($institusi) {
                $query->where('no_institusi', $institusi);
            });
        }
        return $table
            ->query($tugasQuery)
            ->columns([
                TextColumn::make('index')->label('NO')->rowIndex(),
                TextColumn::make('pengguna.nama')->label('Nama'),
                TextColumn::make('tugasSampingan.nama')->label('Tugas Sampingan'),
                TextColumn::make('unitTugasSampingan.nama')->label('Unit Tugas Sampingan'),
                TextColumn::make('senaraiPeringkat.nama')->label('Peringkat'),
                TextColumn::make('senaraisesi.nama')->label('Sesi'),
                TextColumn::make('status.nama')->label('STATUS')->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('SenaraiGredLama.nama')->label('Gred'),
                TextColumn::make('pengguna.institusiJabatan.institusi.nama')->label('Institusi'),
                TextColumn::make('pengguna.institusiJabatan.jabatan.nama')->label('Jabatan'),
                // Tables\Columns\TextColumn::make('tarikh_lantikan')->label('Tarikh Lantikan'),
                // Tables\Columns\TextColumn::make('catatan')->label('Catatan'),
                // IconColumn::make('aktif')
                //     ->label('PENGAKTIFAN')
                //     ->boolean()
                //     ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('pengguna.nama')->label('NAMA')->searchable(),
                TextColumn::make('tugasSampingan.nama')->label('TUGAS SAMPINGAN')->searchable(),
                TextColumn::make('unitTugasSampingan.nama')->label('UNIT TUGAS SAMPINGAN')->searchable()->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('senaraiPeringkat.nama')->label('PERINGKAT')->searchable(),
                TextColumn::make('senaraisesi.nama')->label('SESI')->searchable(),
                TextColumn::make('SenaraiGredLama.nama')->label('GRED')->searchable()->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('pengguna.institusiJabatan.institusi.nama')->label('INSTITUSI')->searchable()->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('pengguna.institusiJabatan.jabatan.nama')->label('JABATAN')->searchable()->toggleable(isToggledHiddenByDefault: true),
                // TextColumn::make('tarikh_lantikan')->label('TARIKH LANTIKAN')->searchable()->toggleable(isToggledHiddenByDefault: true),
                // TextColumn::make('catatan')->label('CATATAN')->searchable()->toggleable(isToggledHiddenByDefault: true)
            ])
            ->defaultSort(fn($query) => $query->orderBy('sesi', 'desc')->orderBy('email', 'asc')->orderBy('peringkat', 'desc'))
            ->deferLoading()
            ->striped()
            ->filters([
                SelectFilter::make('sesi')
                    ->relationship('senaraiSesi', 'nama')
                    ->searchable()
                    ->preload(),
                SelectFilter::make('email')
                    ->label('Pengguna')
                    ->relationship('pengguna', 'nama')
                    ->searchable()
                    ->preload(),
                SelectFilter::make('no_institusi_jabatan')
                    ->options(function () use ($jenis_pengguna, $no_institusi_jabatan) {
                        // Eager load relationships and filter data
                        $query = Pengguna::with('institusiJabatan.jabatan');

                        // Apply additional condition based on jenis_pengguna
                        if ($jenis_pengguna == 1) {
                            // You can add any specific condition for jenis_pengguna == 1 here if needed
                        } elseif ($jenis_pengguna == 2 || $jenis_pengguna == 3 || $jenis_pengguna == 4) {
                            $institusi_jabatan = Pengguna::with('institusiJabatan')->where('no_institusi_jabatan', $no_institusi_jabatan)->first();
                            if ($institusi_jabatan && $institusi_jabatan->institusiJabatan) {
                                $no_institusi = $institusi_jabatan->institusiJabatan->no_institusi;
                                $query->whereHas('institusiJabatan', function ($q) use ($no_institusi) {
                                    $q->where('no_institusi', $no_institusi);
                                });
                            }
                        }

                        return $query->get()
                            ->filter(function ($pengguna) {
                                // Ensure both institusiJabatan and jabatan are not null
                                return $pengguna->institusiJabatan && $pengguna->institusiJabatan->jabatan;
                            })
                            ->mapWithKeys(function ($pengguna) {
                                // Map correct fields
                                return [
                                    $pengguna->institusiJabatan->jabatan->no => $pengguna->institusiJabatan->jabatan->nama
                                ];
                            })
                            ->all(); // Convert collection to array
                    })
                    ->label('Jabatan')
                    ->multiple(),
            ])
            ->recordActions([
            ])  //
            ->toolbarActions([
                //
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListMaklumatTugasSampingans::route('/'),
            // 'create' => Pages\CreateMaklumatTugasSampingan::route('/create'),
            // 'edit' => Pages\EditMaklumatTugasSampingan::route('/{record}/edit'),
        ];
    }

    public static function canCreate(): bool
    {
        return false;
    }

    public static function canViewAny(): bool
    {
        // dd(auth()->user()->roles());
        return auth()
            ->user()
            ->hasAnyRole(['Super Admin', 'Penyelaras','Pengguna','Pengurusan']);
    }

    protected function paginateTableQuery(Builder $query): Paginator
    {
        return $query->fastPaginate($this->getTableRecordsPerPage());
    }
}
