<?php

namespace App\Filament\Resources;

use Filament\Schemas\Schema;
use Filament\Forms\Components\TextInput;
use Filament\Actions\EditAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\BulkActionGroup;
use App\Filament\Resources\JenisPenggunaResource\Pages\ListJenisPenggunas;
use App\Filament\Resources\JenisPenggunaResource\Pages\CreateJenisPengguna;
use App\Filament\Resources\JenisPenggunaResource\Pages\EditJenisPengguna;
use App\Filament\Resources\JenisPenggunaResource\Pages;
use App\Filament\Resources\JenisPenggunaResource\RelationManagers;
use App\Models\JenisPengguna;
use Filament\Forms;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Select;
use Filament\Tables\Columns\IconColumn;

class JenisPenggunaResource extends Resource
{
    protected static ?string $model = JenisPengguna::class;

    protected static string | \BackedEnum | null $navigationIcon = 'heroicon-s-user';

    protected static ?string $navigationLabel = 'JENIS PENGGUNA';

    protected static ?string $pluralModelLabel = 'JENIS PENGGUNA';

    protected static string | \UnitEnum | null $navigationGroup = 'UTILITI';

    protected static ?string $slug = 'jenispengguna';

    //protected static ?string $navigationParentItem = 'Pengguna';

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('nama')->label('Nama')->rules(['required', 'max:100', 'unique:jenis_pengguna,nama']),
                Select::make('aktif')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options([
                        '1' => 'AKTIF',
                        '0' => 'TIDAK AKTIF',
                    ])
                    ->rules(['required']),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('nama'),
                IconColumn::make('aktif')
                    ->label('STATUS')
                    ->boolean(),
                TextColumn::make('nama')->label('NAMA')->searchable(isIndividual: true, isGlobal: false),
            ])
            ->deferLoading()
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make()->label(''),
                DeleteAction::make()->label(''),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    //Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListJenisPenggunas::route('/'),
            'create' => CreateJenisPengguna::route('/create'),
            'edit' => EditJenisPengguna::route('/{record:slug}/edit'),
        ];
    }

    public static function canViewAny(): bool
    {
        // dd(auth()->user()->roles());
        return auth()
            ->user()
            ->hasAnyRole(['Super Admin']);
    }


    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }
}
