<?php

namespace App\Filament\Resources;

use Filament\Schemas\Schema;
use Filament\Forms\Components\TextInput;
use Filament\Actions\EditAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\BulkActionGroup;
use App\Filament\Resources\JabatanResource\Pages\ListJabatans;
use App\Filament\Resources\JabatanResource\Pages\CreateJabatan;
use App\Filament\Resources\JabatanResource\Pages\EditJabatan;
use App\Filament\Resources\JabatanResource\Pages;
use App\Filament\Resources\JabatanResource\RelationManagers;
use App\Models\Jabatan;
use Filament\Forms;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Select;
use Filament\Tables\Columns\IconColumn;

class JabatanResource extends Resource
{
    protected static ?string $model = Jabatan::class;

    protected static string | \BackedEnum | null $navigationIcon = 'heroicon-o-briefcase';

    protected static ?string $navigationLabel = 'JABATAN';

    protected static ?string $pluralModelLabel = 'JABATAN';

    protected static string | \UnitEnum | null $navigationGroup = 'UTILITI';

    protected static ?string $slug = 'jabatan';

    public static function form(Schema $schema): Schema
    {
        return $schema->components([
            TextInput::make('nama')
                ->label('Nama')
                ->rules(['required', 'max:100', 'unique:jabatan,nama']),
            Select::make('aktif')
                ->placeholder('Sila Pilih Maklumat')
                ->options([
                    '1' => 'AKTIF',
                    '0' => 'TIDAK AKTIF',
                ])
                ->rules(['required']),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([TextColumn::make('nama'), IconColumn::make('aktif')->label('STATUS')->boolean(), TextColumn::make('nama')->label('NAMA')->searchable(isIndividual: true, isGlobal: false)])
            ->deferLoading()
            ->filters([
                //
            ])
            ->recordActions([EditAction::make()->label(''), DeleteAction::make()->label('')])
            ->toolbarActions([
                BulkActionGroup::make([
                    //Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
                //
            ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListJabatans::route('/'),
            'create' => CreateJabatan::route('/create'),
            'edit' => EditJabatan::route('/{record:slug}/edit'),
        ];
    }

    public static function canViewAny(): bool
    {
        // dd(auth()->user()->roles());
        return auth()
            ->user()
            ->hasAnyRole(['Super Admin']);
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }
}
