<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->integer('id')->nullable();
            $table->string('email', 100)->nullable();
            $table->string('password', 1000)->nullable();
            $table->string('nama', 100)->nullable();
            $table->string('gambar', 200)->nullable();
            $table->smallInteger('gred')->nullable();
            $table->integer('no_institusi_jabatan')->nullable();
            $table->tinyInteger('aktif')->nullable();
            $table->tinyInteger('jenis_pengguna')->nullable();
            $table->dateTime('tarikh_masa_log_masuk')->nullable();
            $table->string('alamat_ip', 1000)->nullable();
            $table->dateTime('created_at')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->string('slug', 150)->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
