<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('tugas', function (Blueprint $table) {
            $table->bigInteger('no')->nullable();
            $table->integer('no_tugas_sampingan')->nullable();
            $table->integer('no_unit_tugas_sampingan')->nullable();
            $table->string('peringkat')->nullable();
            $table->tinyInteger('pemberat')->nullable();
            $table->string('email', 100)->nullable();
            $table->smallInteger('gred')->nullable();
            $table->integer('no_institusi_jabatan')->nullable();
            $table->date('tarikh_lantikan')->nullable();
            $table->string('sesi')->nullable();
            $table->string('no_status')->nullable();
            $table->string('catatan', 500)->nullable();
            $table->tinyInteger('aktif')->nullable();
            $table->dateTime('created_at')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->string('slug', 150)->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tugas');
    }
};
