<?php

namespace App\Filament\Resources;

use Filament\Schemas\Schema;
use Filament\Actions\BulkActionGroup;
use App\Filament\Resources\JejakAuditResource\Pages\ListJejakAudits;
use App\Filament\Resources\JejakAuditResource\Pages;
use App\Filament\Resources\JejakAuditResource\RelationManagers;
use App\Models\JejakAudit;
use Filament\Forms;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;

class JejakAuditResource extends Resource
{
    protected static ?string $model = JejakAudit::class;

    protected static string | \BackedEnum | null $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationLabel = 'JEJAK AUDIT';

    protected static ?string $pluralModelLabel = 'JEJAK AUDIT';

    protected static string | \UnitEnum | null $navigationGroup = 'LAPORAN';

    protected static ?string $slug = 'jejakaudit';

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        $jejakAudit = JejakAudit::query()
            ->with(['pengguna']);

        return $table
            ->query($jejakAudit)
            ->columns([
                TextColumn::make('id'),
                TextColumn::make('user_type'),
                TextColumn::make('user_id'),
                TextColumn::make('pengguna.email'),
                TextColumn::make('event'),
                TextColumn::make('auditable_type'),
                TextColumn::make('auditable_id'),
                TextColumn::make('old_values'),
                TextColumn::make('new_values'),
                TextColumn::make('url'),
                TextColumn::make('user_agent'),
                TextColumn::make('tags'),
                TextColumn::make('created_at'),
                TextColumn::make('updated_at'),
                TextColumn::make('id')->label('ID')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('user_type')->label('MODEL')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('user_id')->label('USER')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('pengguna.email')->label('USERNAME')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('event')->label('EVENT')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('auditable_type')->label('AUDITABLE TYPE')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('auditable_id')->label('AUDITABLE ID')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('old_values')->label('OLD VALUES')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('new_values')->label('NEW VALUES')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('url')->label('URL')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('user_agent')->label('AGENT')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('tags')->label('TAGS')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('created_at')->label('CREATED')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('updated_at')->label('UPDATED')->searchable(isIndividual: true, isGlobal: false)
            ])
            ->defaultSort('id', 'desc')
            ->deferLoading()
            ->striped()
            ->filters([
                SelectFilter::make('email')
                    ->label('Pengguna')
                    ->relationship('pengguna', 'nama')
                    ->searchable()
                    ->preload(),
            ])
            ->recordActions([
                //
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    //Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListJejakAudits::route('/'),
            // 'create' => Pages\CreateJejakAudit::route('/create'),
            // 'edit' => Pages\EditJejakAudit::route('/{record:slug}/edit'),
        ];
    }

    public static function canViewAny(): bool
    {
        // dd(auth()->user()->roles());
        return auth()
            ->user()
            ->hasAnyRole(['Super Admin']);
    }


    public static function canCreate(): bool
    {
        return false;
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }
}
