<?php

namespace App\Filament\Resources;

use Filament\Schemas\Schema;
use Filament\Actions\EditAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\BulkActionGroup;
use App\Filament\Resources\InstitusiJabatanResource\Pages\ListInstitusiJabatans;
use App\Filament\Resources\InstitusiJabatanResource\Pages\CreateInstitusiJabatan;
use App\Filament\Resources\InstitusiJabatanResource\Pages\EditInstitusiJabatan;
use App\Filament\Resources\InstitusiJabatanResource\Pages;
use App\Filament\Resources\InstitusiJabatanResource\RelationManagers;
use App\Models\InstitusiJabatan;
use Filament\Forms;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Select;
use Filament\Tables\Columns\IconColumn;

use App\Models\Institusi;
use App\Models\Jabatan;

class InstitusiJabatanResource extends Resource
{
    protected static ?string $model = InstitusiJabatan::class;

    protected static string | \BackedEnum | null $navigationIcon = 'heroicon-s-cube-transparent';

    protected static ?string $navigationLabel = 'INSTITUSI JABATAN';

    protected static ?string $pluralModelLabel = 'INSTITUSI JABATAN';

    protected static string | \UnitEnum | null $navigationGroup = 'UTILITI';

    protected static ?string $slug = 'institusijabatan';

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('no_institusi')
                    ->label('Institusi')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options(Institusi::all()->pluck('nama', 'no'))
                    ->searchable()
                    ->rules(['required']),
                Select::make('no_jabatan')
                    ->label('Jabatan')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options(Jabatan::all()->pluck('nama', 'no'))
                    ->searchable()
                    ->rules(['required']),
                Select::make('unit_tugas_sampingan')
                    ->label('Tugas Sampingan')
                    ->placeholder('Sila Pilih Maklumat')
                    ->rules(['required'])
                    ->options([
                        '1' => 'AKTIF',
                        '0' => 'TIDAK AKTIF',
                    ]),
                Select::make('aktif')
                    ->label('Status')
                    ->placeholder('Sila Pilih Maklumat')
                    ->rules(['required'])
                    ->options([
                        '1' => 'AKTIF',
                        '0' => 'TIDAK AKTIF',
                    ])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('institusi.nama')
                    ->label('INSTITUSI'),
                TextColumn::make('jabatan.nama')
                    ->label('JABATAN'),
                IconColumn::make('unit_tugas_sampingan')
                    ->label('TUGAS SAMPINGAN')
                    ->boolean(),
                IconColumn::make('aktif')
                    ->label('STATUS')
                    ->boolean(),
                TextColumn::make('institusi.nama')->label('INSTITUSI')->sortable()->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('jabatan.nama')->label('JABATAN')->sortable()->searchable(isIndividual: true, isGlobal: false),
            ])
            ->deferLoading()
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make()->label(''),
                DeleteAction::make()->label(''),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    //Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListInstitusiJabatans::route('/'),
            'create' => CreateInstitusiJabatan::route('/create'),
            'edit' => EditInstitusiJabatan::route('/{record:slug}/edit'),
        ];
    }

    public static function canViewAny(): bool
    {
        // dd(auth()->user()->roles());
        return auth()
            ->user()
            ->hasAnyRole(['Super Admin']);
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }
}
