<?php

namespace App\Filament\Resources;

use Filament\Schemas\Schema;
use Filament\Forms\Components\TextInput;
use Filament\Actions\EditAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\BulkActionGroup;
use App\Filament\Resources\GredResource\Pages\ListGreds;
use App\Filament\Resources\GredResource\Pages\CreateGred;
use App\Filament\Resources\GredResource\Pages\EditGred;
use App\Filament\Resources\GredResource\Pages;
use App\Filament\Resources\GredResource\RelationManagers;
use App\Models\Gred;
use Filament\Forms;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Select;
use Illuminate\Database\Eloquent\Model;

class GredResource extends Resource
{
    protected static ?string $model = Gred::class;

    protected static string | \BackedEnum | null $navigationIcon = 'heroicon-c-user-circle';

    protected static ?string $navigationLabel = 'GRED';

    protected static ?string $pluralModelLabel = 'GRED';

    protected static string | \UnitEnum | null $navigationGroup = 'UTILITI';

    protected static ?string $slug = 'gred';

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('gred')->label('Gred')->rules(['required', 'max:5', 'unique:gred,gred']),
                TextInput::make('nama')->label('Nama')->rules(['required', 'max:100', 'unique:gred,nama']),
                Select::make('aktif')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options([
                        '1' => 'AKTIF',
                        '0' => 'TIDAK AKTIF',
                    ])
                    ->rules(['required']),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('index')->label('NO')->rowIndex(),
                TextColumn::make('nama'),
                IconColumn::make('aktif')
                    ->label('STATUS')
                    ->boolean(),
                TextColumn::make('nama')->label('NAMA')->searchable(),
            ])
            ->deferLoading()
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make()->label(''),
                DeleteAction::make()->label(''),

            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    //Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListGreds::route('/'),
            'create' => CreateGred::route('/create'),
            'edit' => EditGred::route('/{record:slug}/edit'),
        ];
    }

    public static function canViewAny(): bool
    {
        // dd(auth()->user()->roles());
        return auth()
            ->user()
            ->hasAnyRole(['Super Admin', 'Penyelaras']);
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }

    public static function canDelete(Model $record): bool
    {
        return ! $record->tugas()->exists();
    }

}
