<?php

namespace App\Filament\Helper;

use Filament\Auth\Pages\Login;
use Filament\Schemas\Schema;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\TextInput;

class LoginMakeUp extends Login
{
    public function form(Schema $schema): Schema
    {
        return $schema->components([
            // Logo via Blade view
            Placeholder::make('logo')
                ->view('filament.components.logo-placeholder')
                ->disableLabel(), // optional

            // Email
            TextInput::make('email')
                ->label('Emel')
                ->required(),

            // Password
            TextInput::make('password')
                ->label('Kata Laluan')
                ->revealable()
                ->password()
                ->required(),
        ]);
    }

    protected function getCredentialsFromFormData(array $data): array
    {
        return [
            'email' => $data['email'],
            'password' => $data['password'],
        ];
    }
}
