<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use App\Models\Pengguna;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class ExcelSenaraiPenggunaExport implements FromCollection, WithHeadings, WithEvents, ShouldAutoSize, WithMapping
{
  /**
   * @return Collection
   */
  protected $institusi;
  protected $jabatan;


  function __construct($institusi, $jabatan)
  {
    $this->institusi = $institusi;
    $this->jabatan = $jabatan;
  }

  public function headings(): array
  {
    return ["NAMA", "JABATAN", "GRED", "EMAIL"];
  }


  public function map($laporan): array
  {

    return [
      $laporan->nama,
      $laporan->nama_jabatan,
      $laporan->nama_gred,
      $laporan->email,
    ];
  }

  /**
   * @return Collection
   */
  public function collection()
  {
    return collect(Pengguna::senaraiPengguna($this->institusi, $this->jabatan));
  }

  public function registerEvents(): array
  {
    return [
      AfterSheet::class => function (AfterSheet $event) {
        $event->sheet->getStyle('A1:N1')->applyFromArray([
          'font' => [
            'bold' => true
          ]
        ]);
      },
    ];
  }
}
