<?php

namespace App\Policies;

use App\Models\User;

class RolePolicy
{
    public function viewAny(User $user): bool
    {
        // EMERGENCY DEBUG: Return true just to see if the menu appears
        // return true;

        // REAL LOGIC: Check by ID or Role Name
        return $user->id === 1 || $user->hasRole('Super Admin');
    }

    public function view(User $user): bool { return $this->viewAny($user); }
    public function create(User $user): bool { return $this->viewAny($user); }
    public function update(User $user): bool { return $this->viewAny($user); }
    public function delete(User $user): bool { return $this->viewAny($user); }
}
