<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Auditable as AuditableTrait;

class JenisLaporan extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'jenis_laporan';

    protected $primaryKey = 'no';

    protected $fillable = ['no', 'nama', 'no_jenis_dokumen', 'jenis_dokumen_rujukan', 'label_tarikh', 'aktif'];

    public function jenisDokumen()
    {
        return $this->belongsTo(JenisDokumen::class, 'no_jenis_dokumen', 'no');
    }

    public function getRouteKeyName(): string
    {
        return 'slug'; // Laravel will now use slug for route model binding
    }

}
