<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Auditable as AuditableTrait;

class DokumenRujukan extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'dokumen_rujukan';

    protected $primaryKey = 'no';

    protected $fillable = ['no', 'nama', 'no_sesi', 'no_dokumen', 'email_ketua_jabatan', 'jenis_dokumen_rujukan', 'aktif'];

    protected static function boot()
    {
        parent::boot();

        // Define an event listener for the creating event
        static::creating(function ($dokumen_rujukan) {
            // Nama uppercase
            $dokumen_rujukan->nama = strtoupper($dokumen_rujukan->nama);

            // Generate slug jika kosong
            if (empty($dokumen_rujukan->slug)) {
                $dokumen_rujukan->slug = substr(str_replace('-', '', \Illuminate\Support\Str::uuid()) . \Illuminate\Support\Str::upper(\Illuminate\Support\Str::random(68)), 0, 60);
            }
        });
    }

    public function sesi()
    {
        return $this->belongsTo(Sesi::class, 'no_sesi', 'no');
    }

    public function pengguna()
    {
        return $this->belongsTo(Pengguna::class, 'email_ketua_jabatan', 'email');
    }

    public function jenislaporan()
    {
        return $this->hasMany(JenisLaporan::class, 'no', 'jenis_dokumen_rujukan');
    }

    public function getRouteKeyName(): string
    {
        return 'slug'; // Laravel will now use slug for route model binding
    }
}
