<?php

namespace App\Filament\Widgets;

use App\Models\Pengguna;
use Filament\Widgets\Widget;
use Illuminate\Support\Facades\Auth;

class GambarProfilWidget extends Widget
{
    protected static string $view = 'filament.widgets.gambar-profil-widget';

    protected int | string | array $columnSpan = 1;

    public $imageUrl;
    public $institusi;
    public $jabatan;
    public $gred;

    public function mount()
    {

        $pengguna = Pengguna::with('institusiJabatan','senaraiGred')->where('email',Auth::user()->email)->first();

        // Set the image URL. You can customize this as needed.
        $this->imageUrl = asset('storage/gambar/'.Auth::user()->email.'/'.Auth::user()->gambar);
        $this->institusi = $pengguna->institusiJabatan->institusi->nama;
        $this->jabatan = $pengguna->institusiJabatan->jabatan->nama;
        $this->gred = $pengguna->senaraiGred->nama;
    }
}
