<?php

namespace App\Filament\Resources;

use App\Filament\Resources\UnitTugasSampinganResource\Pages;
use App\Filament\Resources\UnitTugasSampinganResource\RelationManagers;
use App\Models\UnitTugasSampingan;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Select;


class UnitTugasSampinganResource extends Resource
{
    protected static ?string $model = UnitTugasSampingan::class;

    protected static ?string $navigationIcon = 'heroicon-s-document-text';

    protected static ?string $navigationLabel = 'UNIT TUGAS SAMPINGAN';

    protected static ?string $pluralModelLabel = 'UNIT TUGAS SAMPINGAN';

    protected static ?string $navigationGroup = 'UTILITI';

    protected static ?string $slug = 'unittugassampingan';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('nama')->label('Nama')->rules(['required', 'max:100', 'unique:unit_tugas_sampingan,nama']),
                Select::make('aktif')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options([
                        '1' => 'AKTIF',
                        '0' => 'TIDAK AKTIF',
                    ])
                    ->rules(['required']),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nama'),
                IconColumn::make('aktif')
                    ->label('STATUS')
                    ->boolean(),
                TextColumn::make('nama')->label('NAMA')->searchable(isIndividual: true, isGlobal: false),
            ])
            ->deferLoading()
            ->striped()
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make()->label(''),
                Tables\Actions\DeleteAction::make()->label(''),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    //Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListUnitTugasSampingans::route('/'),
            'create' => Pages\CreateUnitTugasSampingan::route('/create'),
            'edit' => Pages\EditUnitTugasSampingan::route('/{record:slug}/edit'),
        ];
    }

    public static function canViewAny(): bool
    {
        $userId = auth()->user()->jenis_pengguna;
        return in_array($userId, [1]);
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }
}
