<?php

namespace App\Filament\Resources;

use App\Filament\Resources\JenisLaporanResource\Pages;
use App\Filament\Resources\JenisLaporanResource\RelationManagers;
use App\Models\JenisLaporan;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Select;

use App\Models\JenisDokumen;

class JenisLaporanResource extends Resource
{
    protected static ?string $model = JenisLaporan::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $navigationLabel = 'JENIS LAPORAN';

    protected static ?string $pluralModelLabel = 'JENIS LAPORAN';

    protected static ?string $navigationGroup = 'UTILITI';

    protected static ?string $slug = 'jenislaporan';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('nama')->label('Nama')->rules(['required', 'max:200', 'unique:jenis_laporan,nama']),
                Select::make('no_jenis_dokumen')
                    ->label('Jenis Laporan')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options(JenisDokumen::all()->pluck('nama', 'no'))
                    ->searchable()
                    ->rules(['required']),
                Select::make('label_tarikh')
                    ->label('Label Tarikh')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options([
                        '1' => 'AKTIF',
                        '0' => 'TIDAK AKTIF',
                    ]),
                Select::make('aktif')
                    ->label('Status')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options([
                        '1' => 'AKTIF',
                        '0' => 'TIDAK AKTIF',
                    ])
                    ->rules(['required'])
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nama')->label('Nama'),
                Tables\Columns\TextColumn::make('jenisdokumen.nama')->label('Dokumen'),
                IconColumn::make('label_tarikh')
                    ->label('LABEL TARIKH')
                    ->boolean(),
                IconColumn::make('aktif')
                    ->label('STATUS')
                    ->boolean(),
                TextColumn::make('nama')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('jenisdokumen.nama')->label('JENIS DOKUMEN')->searchable(isIndividual: true, isGlobal: false)
            ])
            ->deferLoading()
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make()->label(''),
                Tables\Actions\DeleteAction::make()->label(''),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    //Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListJenisLaporans::route('/'),
            'create' => Pages\CreateJenisLaporan::route('/create'),
            'edit' => Pages\EditJenisLaporan::route('/{record:slug}/edit'),
        ];
    }

    public static function canViewAny(): bool
    {
        $userId = auth()->user()->jenis_pengguna;
        return in_array($userId, [1]);
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }
}
