<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Auditable as AuditableTrait;

class JenisPengguna extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'jenis_pengguna';

    protected $primaryKey = 'no';

    protected $fillable = ['no', 'nama', 'aktif'];

    protected static function boot()
    {
        parent::boot();

        // Define an event listener for the creating event
        static::creating(function ($jenis_pengguna) {
            // Modify the 'nama' attribute to uppercase before insertion
            $jenis_pengguna->nama = strtoupper($jenis_pengguna->nama);
        });
    }

    public function getRouteKeyName(): string
    {
        return 'slug'; // Laravel will now use slug for route model binding
    }

}
