<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Auditable as AuditableTrait;

class JenisDokumen extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;
    protected $table = 'jenis_dokumen';

    protected $primaryKey = 'no';

    protected $fillable = ['no', 'nama', 'aktif'];

    public function getRouteKeyName(): string
    {
        return 'slug'; // Laravel will now use slug for route model binding
    }

}
