<?php

namespace App\Filament\Widgets;

use App\Models\InstitusiJabatan;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Card;
use Illuminate\Support\Facades\Auth;

use App\Models\Pengguna;
use App\Models\Institusi;
use App\Models\Jabatan;
use App\Models\Sesi;
use App\Models\Tugasan;

class Stats extends BaseWidget
{
    protected function getStats(): array
    {
        $jenis_pengguna = Auth::user()->jenis_pengguna;
        $email = Auth::user()->email;
        $no_institusi_jabatan = Auth::user()->no_institusi_jabatan;
        $no_institusi = InstitusiJabatan::where('no', $no_institusi_jabatan)->first();

        $sesi_terkini = Sesi::where('aktif', 1)->orderByDesc('sesi_mula')->first();

        switch ($jenis_pengguna) {
            case 1:
                return [
                    Card::make('JUMLAH PENGGUNA', Pengguna::where('aktif',1)->count()),
                    Card::make('JUMLAH INSTITUSI', Institusi::where('aktif',1)->count()),
                    Card::make('JUMLAH JABATAN', Jabatan::where('aktif',1)->count()),
                    Card::make('JUMLAH SESI', Sesi::where('aktif',1)->count()),
                    Card::make('JUMLAH TUGAS', Tugasan::where('aktif',1)->count()),
                    Card::make('JUMLAH TUGAS PERINGKAT POLIMAS', Tugasan::where('aktif',1)->where('peringkat', 2)->count()),
                    Card::make('JUMLAH TUGAS PERINGKAT JABATAN', Tugasan::where('aktif',1)->where('peringkat', 1)->count()),
                ];
            case 2:
                return [
                    Card::make('JUMLAH PENGGUNA', Pengguna::where('aktif',1)->where('no_institusi_jabatan', $no_institusi_jabatan)->count()),
                    Card::make('JUMLAH TUGAS', Tugasan::where('aktif',1)->where('no_institusi_jabatan', $no_institusi_jabatan)->count()),
                    Card::make('JUMLAH TUGAS PERINGKAT POLIMAS', Tugasan::where('aktif',1)->where('no_institusi_jabatan', $no_institusi_jabatan)->where('peringkat', 2)->count()),
                    Card::make('JUMLAH TUGAS PERINGKAT JABATAN', Tugasan::where('aktif',1)->where('no_institusi_jabatan', $no_institusi_jabatan)->where('peringkat', 1)->count()),
                ];
            case 3:
    // Dapatkan sesi terkini
    $sesi_terkini = Sesi::where('aktif', 1)->orderByDesc('no')->first();

    // Dapatkan sesi dengan 'no' kurang 1 daripada sesi terkini
    $sesi_sebelumnya = Sesi::where('no', $sesi_terkini->no - 1)->first();

    // Semak jika ada tugasan dalam sesi terkini
    $jumlah_tugasan_terkini = Tugasan::where('aktif', 1)
        ->where('sesi', $sesi_terkini->no)
        ->where('email', $email)
        ->count();

    // Jika tiada tugasan dalam sesi terkini, guna sesi sebelumnya
    if ($jumlah_tugasan_terkini === 0 && $sesi_sebelumnya) {
        $sesi_digunakan = $sesi_sebelumnya;
    } else {
        $sesi_digunakan = $sesi_terkini;
    }

    return [
        Card::make('JUMLAH TUGAS', Tugasan::where('aktif', 1)
            ->where('sesi', $sesi_digunakan->no)
            ->where('email', $email)
            ->count()
        )->description("SESI: " . $sesi_digunakan->nama),

        Card::make('JUMLAH TUGAS PERINGKAT POLIMAS', Tugasan::where('aktif', 1)
            ->where('email', $email)
            ->where('peringkat', 2)
            ->where('sesi', $sesi_digunakan->no)
            ->count()
        )->description("SESI: " . $sesi_digunakan->nama),

        Card::make('JUMLAH TUGAS PERINGKAT JABATAN', Tugasan::where('aktif', 1)
            ->where('email', $email)
            ->where('peringkat', 1)
            ->where('sesi', $sesi_digunakan->no)
            ->count()
        )->description("SESI: " . $sesi_digunakan->nama),

        // Jumlah keseluruhan tanpa penapisan sesi
        Card::make('JUMLAH TUGAS KESELURUHAN', Tugasan::where('aktif', 1)
            ->where('email', $email)
            ->count()
        ),

        Card::make('JUMLAH TUGAS PERINGKAT POLIMAS KESELURUHAN', Tugasan::where('aktif', 1)
            ->where('email', $email)
            ->where('peringkat', 2)
            ->count()
        ),

        Card::make('JUMLAH TUGAS PERINGKAT JABATAN KESELURUHAN', Tugasan::where('aktif', 1)
            ->where('email', $email)
            ->where('peringkat', 1)
            ->count()
        ),
    ];

            case 4:
                return [
                    Card::make('JUMLAH PENGGUNA', function () use ($no_institusi) {
                        return Pengguna::where('aktif',1)->whereHas('institusiJabatan', function ($query) use ($no_institusi) {
                            $query->where('no_institusi', $no_institusi->no_institusi);
                        })->count();
                    }),

                    Card::make('JUMLAH TUGAS', function () use ($no_institusi) {
                        return Tugasan::where('aktif',1)->whereHas('pengguna', function ($query) use ($no_institusi) {
                            $query->whereHas('institusiJabatan', function ($subQuery) use ($no_institusi) {
                                $subQuery->where('no_institusi', $no_institusi->no_institusi);
                            });
                        })->count();
                    }),

                    Card::make('JUMLAH TUGAS PERINGKAT POLIMAS', function () use ($no_institusi) {
                        return Tugasan::where('aktif',1)->where('peringkat', 1)->whereHas('pengguna', function ($query) use ($no_institusi) {
                            $query->whereHas('institusiJabatan', function ($subQuery) use ($no_institusi) {
                                $subQuery->where('no_institusi', $no_institusi->no_institusi);
                            });
                        })->count();
                    }),

                    Card::make('JUMLAH TUGAS PERINGKAT JABATAN', function () use ($no_institusi) {
                        return Tugasan::where('aktif',1)->where('peringkat', 2)->whereHas('pengguna', function ($query) use ($no_institusi) {
                            $query->whereHas('institusiJabatan', function ($subQuery) use ($no_institusi) {
                                $subQuery->where('no_institusi', $no_institusi->no_institusi);
                            });
                        })->count();
                    }),

                ];
            default:
                return [];
        }
    }

    public static function canView(): bool
    {
        $userId = auth()->user()->jenis_pengguna;
        return in_array($userId, [1, 2, 3, 4]);
    }
}
