<?php

namespace App\Filament\Resources\PenggunaResource\Pages;

use App\Models\Tugasan;
use App\Filament\Resources\PenggunaResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditPengguna extends EditRecord
{
    protected static string $resource = PenggunaResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()->visible(function () {
                // Rekod user semasa
                $user = $this->record;

                // Check jika ada tugasan guna email user
                return !Tugasan::where('email', $user->email)->exists();
            }),
        ];
    }

    // ✅ Tajuk di tab / page title
    public function getTitle(): string
    {
        return 'SUNTING PENGGUNA';
    }
}
