<?php

namespace App\Providers;

use App\Listeners\KemaskiniLogMasuk;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use App\Policies\RolePolicy;
use App\Policies\PermissionPolicy;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Event;
use Illuminate\Auth\Events\Login;
use Filament\Facades\Filament;
use Illuminate\Support\Facades\Auth;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Schema::defaultStringLength(191);

        Gate::policy(Role::class, RolePolicy::class);
        Gate::policy(Permission::class, PermissionPolicy::class);

        Event::listen(Login::class, KemaskiniLogMasuk::class);

        // ✅ Filament Footer System Version
        Filament::serving(function () {
            Filament::registerRenderHook('panels::footer', function () {
                $user = Auth::user();

                // Only admin can see
                if (!$user || !$user->hasRole(1)) {
                    return null;
                }

                return view('filament.partials.system-version');
            });
        });
    }
}
