<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('dokumen_rujukan', function (Blueprint $table) {
            $table->integer('no')->nullable();
            $table->string('nama', 200)->nullable();
            $table->string('no_sesi')->nullable();
            $table->string('no_dokumen')->nullable();
            $table->string('email_ketua_jabatan', 100)->nullable();
            $table->integer('jenis_dokumen_rujukan')->nullable();
            $table->tinyInteger('aktif')->nullable();
            $table->dateTime('created_at')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->string('slug', 150)->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('dokumen_rujukan');
    }
};
