<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Auditable as AuditableTrait;

class SenaraiJPKA extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'senarai_jpka';

    protected $primaryKey = 'no';

    protected $fillable = ['no', 'no_dokumen_rujukan', 'email', 'no_jawatan', 'no_institusi', 'kedudukan', 'aktif'];

    public function pengguna()
    {
        return $this->belongsTo(Pengguna::class, 'email', 'email');
    }

    public function jenisDokumen()
    {
        return $this->belongsTo(JenisDokumen::class, 'no_jenis_dokumen', 'no');
    }

    public function dokumenrujukan()
    {
        return $this->hasMany(DokumenRujukan::class, 'no', 'no_dokumen_rujukan');
    }

    public function gred()
    {
        return $this->belongsTo(Gred::class, 'no_jawatan', 'no');
    }

    public function institusijabatan()
    {
        return $this->belongsTo(InstitusiJabatan::class, 'no', 'no_institusi');
    }

    public function jawatan()
    {
        return $this->belongsTo(Jawatan::class, 'email', 'email');
    }

    public function getRouteKeyName(): string
    {
        return 'slug'; // Laravel will now use slug for route model binding
    }

}
