<?php

namespace App\Filament\Resources;

use App\Filament\Resources\MaklumatStafResource\Pages;
use App\Filament\Resources\MaklumatStafResource\RelationManagers;
use App\Models\User;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Support\Facades\Hash;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Columns\IconColumn;
use Filament\Forms\Components\FileUpload;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Filters\SelectFilter;
use Illuminate\Support\Facades\Auth;

use App\Models\InstitusiJabatan;

class MaklumatStafResource extends Resource
{
    protected static ?string $model = User::class;

    protected static ?string $navigationIcon = 'heroicon-s-user-group';

    protected static ?string $navigationLabel = 'DIREKTORI STAF';

    protected static ?string $pluralModelLabel = 'DIREKTORI STAF';

    protected static ?string $navigationGroup = 'DIREKTORI';

    protected static ?string $slug = 'maklumatstaf';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {

        $jenis_pengguna = auth()->user()->roles()->value('id');
        $email = Auth::user()->email;
        $no_institusi_jabatan = Auth::user()->no_institusi_jabatan;

        $penggunaQuery = User::query()
            ->with(['senaraiGred', 'institusiJabatan'])->where('aktif', 1)->orderBy('nama', 'asc');

        if ($jenis_pengguna == 1) {
            // If user is not admin, filter jenis laporan based on user's role
            // You can add your filtering logic here
        } elseif ($jenis_pengguna == 2 || $jenis_pengguna == 3 || $jenis_pengguna == 4) {
            // If user is of type 4, exclude specific jenis laporan
            $institusi_jabatan = InstitusiJabatan::where('no', $no_institusi_jabatan)->first();
            $institusi = $institusi_jabatan->no_institusi;

            $penggunaQuery->whereHas('institusiJabatan', function ($query) use ($institusi) {
                $query->where('no_institusi', $institusi);
            });
        }

        return $table
            ->query($penggunaQuery)
            ->columns([
                Tables\Columns\TextColumn::make('index')->label('NO')->rowIndex(),
                ImageColumn::make('gambar')
                    ->label('GAMBAR')
                    ->width(150)
                    ->height(150)
                    ->circular()
                    ->getStateUsing(function ($record) {
                        return url('storage/gambar/' . $record->email . '/' . $record->gambar);
                    }),
                Tables\Columns\TextColumn::make('nama')->label('NAMA'),
                Tables\Columns\TextColumn::make('email')->label('EMEL'),
                Tables\Columns\TextColumn::make('senaraiGred.nama')->label('GRED'),
                Tables\Columns\TextColumn::make('institusiJabatan.institusi.nama')->label('INSTITUSI'),
                Tables\Columns\TextColumn::make('institusiJabatan.jabatan.nama')->label('JABATAN'),
                TextColumn::make('nama')->label('NAMA')->searchable(),
                TextColumn::make('email')->label('EMEL')->searchable(),
                TextColumn::make('institusiJabatan.institusi.nama')->label('INSTITUSI')->searchable()->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('institusiJabatan.jabatan.nama')->label('JABATAN')->searchable()
            ])
            ->defaultSort('nama')
            ->deferLoading()
            ->striped()
            ->filters([
                SelectFilter::make('no_institusi_jabatan')
                    ->options(function () use ($jenis_pengguna, $no_institusi_jabatan) {
                        // Eager load relationships and filter data
                        $query = User::with('institusiJabatan.jabatan');

                        // Apply additional condition based on jenis_pengguna
                        if ($jenis_pengguna == 1) {
                            // You can add any specific condition for jenis_pengguna == 1 here if needed
                        } elseif ($jenis_pengguna == 2 || $jenis_pengguna == 3 || $jenis_pengguna == 4) {
                            $institusi_jabatan = User::with('institusiJabatan')->where('no_institusi_jabatan', $no_institusi_jabatan)->first();
                            if ($institusi_jabatan && $institusi_jabatan->institusiJabatan) {
                                $no_institusi = $institusi_jabatan->institusiJabatan->no_institusi;
                                $query->whereHas('institusiJabatan', function ($q) use ($no_institusi) {
                                    $q->where('no_institusi', $no_institusi);
                                });
                            }
                        }

                        return $query->get()
                            ->filter(function ($pengguna) {
                                // Ensure both institusiJabatan and jabatan are not null
                                return $pengguna->institusiJabatan && $pengguna->institusiJabatan->jabatan;
                            })
                            ->mapWithKeys(function ($pengguna) {
                                // Map correct fields
                                return [
                                    $pengguna->institusiJabatan->jabatan->no => $pengguna->institusiJabatan->jabatan->nama
                                ];
                            })
                            ->all(); // Convert collection to array
                    })
                    ->label('Jabatan')
                    ->multiple(),
                SelectFilter::make('gred')
                    ->relationship('senaraiGred', 'nama')
                    ->searchable()
                    ->multiple()
                    ->preload(),
            ])
            ->actions([
                //
            ])
            ->bulkActions([
                //
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListMaklumatStafs::route('/'),
            // 'create' => Pages\CreateMaklumatStaf::route('/create'),
            // 'edit' => Pages\EditMaklumatStaf::route('/{record}/edit'),
        ];
    }

    public static function canCreate(): bool
    {
        return false;
    }

    public static function canViewAny(): bool
    {
        // dd(auth()->user()->roles());
        return auth()
            ->user()
            ->hasAnyRole(['Super Admin', 'Penyelaras','Pengguna','Pengurusan']);
    }

}
