<?php

namespace App\Filament\Resources;

use App\Filament\Resources\JabatanResource\Pages;
use App\Filament\Resources\JabatanResource\RelationManagers;
use App\Models\Jabatan;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Select;
use Filament\Tables\Columns\IconColumn;

class JabatanResource extends Resource
{
    protected static ?string $model = Jabatan::class;

    protected static ?string $navigationIcon = 'heroicon-o-briefcase';

    protected static ?string $navigationLabel = 'JABATAN';

    protected static ?string $pluralModelLabel = 'JABATAN';

    protected static ?string $navigationGroup = 'UTILITI';

    protected static ?string $slug = 'jabatan';

    public static function form(Form $form): Form
    {
        return $form->schema([
            Forms\Components\TextInput::make('nama')
                ->label('Nama')
                ->rules(['required', 'max:100', 'unique:jabatan,nama']),
            Select::make('aktif')
                ->placeholder('Sila Pilih Maklumat')
                ->options([
                    '1' => 'AKTIF',
                    '0' => 'TIDAK AKTIF',
                ])
                ->rules(['required']),
        ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([Tables\Columns\TextColumn::make('nama'), IconColumn::make('aktif')->label('STATUS')->boolean(), TextColumn::make('nama')->label('NAMA')->searchable(isIndividual: true, isGlobal: false)])
            ->deferLoading()
            ->filters([
                //
            ])
            ->actions([Tables\Actions\EditAction::make()->label(''), Tables\Actions\DeleteAction::make()->label('')])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    //Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
                //
            ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListJabatans::route('/'),
            'create' => Pages\CreateJabatan::route('/create'),
            'edit' => Pages\EditJabatan::route('/{record:slug}/edit'),
        ];
    }

    public static function canViewAny(): bool
    {
        // dd(auth()->user()->roles());
        return auth()
            ->user()
            ->hasAnyRole(['Super Admin']);
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }
}
