<?php

namespace App\Filament\Resources;

use App\Filament\Resources\GredResource\Pages;
use App\Filament\Resources\GredResource\RelationManagers;
use App\Models\Gred;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Select;
use Illuminate\Database\Eloquent\Model;

class GredResource extends Resource
{
    protected static ?string $model = Gred::class;

    protected static ?string $navigationIcon = 'heroicon-c-user-circle';

    protected static ?string $navigationLabel = 'GRED';

    protected static ?string $pluralModelLabel = 'GRED';

    protected static ?string $navigationGroup = 'UTILITI';

    protected static ?string $slug = 'gred';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('gred')->label('Gred')->rules(['required', 'max:5', 'unique:gred,gred']),
                Forms\Components\TextInput::make('nama')->label('Nama')->rules(['required', 'max:100', 'unique:gred,nama']),
                Select::make('aktif')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options([
                        '1' => 'AKTIF',
                        '0' => 'TIDAK AKTIF',
                    ])
                    ->rules(['required']),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('index')->label('NO')->rowIndex(),
                Tables\Columns\TextColumn::make('nama'),
                IconColumn::make('aktif')
                    ->label('STATUS')
                    ->boolean(),
                TextColumn::make('nama')->label('NAMA')->searchable(),
            ])
            ->deferLoading()
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make()->label(''),
                Tables\Actions\DeleteAction::make()->label(''),

            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    //Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListGreds::route('/'),
            'create' => Pages\CreateGred::route('/create'),
            'edit' => Pages\EditGred::route('/{record:slug}/edit'),
        ];
    }

    public static function canViewAny(): bool
    {
        // dd(auth()->user()->roles());
        return auth()
            ->user()
            ->hasAnyRole(['Super Admin', 'Penyelaras']);
    }

    public static function getNavigationBadge(): ?string
    {
        return static::getModel()::count();
    }

    public static function canDelete(Model $record): bool
    {
        return ! $record->tugas()->exists();
    }

}
