<?php

namespace App\Filament\Helper;

use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Pages\Auth\Login;

class LoginMakeUp extends Login
{
    public function form(Form $form): Form
    {
        return $form->schema([
            // Logo via Blade view
            Placeholder::make('logo')
                ->view('filament.components.logo-placeholder')
                ->disableLabel(), // optional

            // Email
            TextInput::make('email')
                ->label('EMEL')
                ->required(),

            // Password
            TextInput::make('password')
                ->label('KATA LALUAN')
                ->revealable()
                ->password()
                ->required(),
        ]);
    }

    protected function getCredentialsFromFormData(array $data): array
    {
        return [
            'email' => $data['email'],
            'password' => $data['password'],
        ];
    }
}
