<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('language_lines', function (Blueprint $table) {
            $table->bigInteger('id')->nullable();
            $table->string('group', 191)->nullable();
            $table->text('key')->nullable();
            $table->string('text')->nullable();
            $table->string('metadata')->nullable();
            $table->string('namespace', 191)->nullable();
            $table->timestamp('deleted_at')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('language_lines');
    }
};
