<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Auditable as AuditableTrait;

class UnitTugasSampingan extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'unit_tugas_sampingan';

    protected $primaryKey = 'no';

    protected $fillable = ['no', 'nama', 'aktif'];

    protected static function boot()
    {
        parent::boot();

        // Define an event listener for the creating event
        static::creating(function ($unit_tugas_sampingan) {
            // Modify the 'nama' attribute to uppercase before insertion
            $unit_tugas_sampingan->nama = strtoupper($unit_tugas_sampingan->nama);
        });
    }

    public function tugasan()
    {
        return $this->hasMany(Tugasan::class, 'no_unit_tugas_sampingan', 'no');
    }

    public function getRouteKeyName(): string
    {
        return 'slug'; // Laravel will now use slug for route model binding
    }

}
