<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TugasSampingan extends Model
{
    use HasFactory;

    protected $table = 'tugas_sampingan';

    protected $primaryKey = 'no';

    protected $fillable = ['no', 'nama', 'aktif'];

    protected static function boot()
    {
        parent::boot();

        // Define an event listener for the creating event
        static::creating(function ($tugas_sampingan) {
            // Modify the 'nama' attribute to uppercase before insertion
            $tugas_sampingan->nama = strtoupper($tugas_sampingan->nama);
        });
    }

    public function tugasan()
    {
        return $this->hasMany(Tugasan::class, 'no_tugas_sampingan', 'no');
    }

    public function getRouteKeyName(): string
    {
        return 'slug'; // Laravel will now use slug for route model binding
    }

}
