<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SenaraiPenggunaDokumenRujukanResource\Pages;
use App\Filament\Resources\SenaraiPenggunaDokumenRujukanResource\RelationManagers;
use App\Models\DokumenRujukan;
use App\Models\SenaraiJPKA;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Columns\IconColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Forms\Components\Select;
use Illuminate\Support\Facades\Auth;

use App\Models\Pengguna;
use App\Models\Sesi;
use App\Models\JenisLaporan;
use App\Models\Jawatan;
use App\Models\InstitusiJabatan;
use App\Models\Gred;

class SenaraiPenggunaDokumenRujukanResource extends Resource
{
    protected static ?string $model = SenaraiJPKA::class;

    protected static ?string $navigationIcon = 'heroicon-s-document-text';

    public static ?string $label = 'DOKUMEN RUJUKAN (SENARAI)';

    protected static ?string $title = 'DOKUMEN RUJUKAN (SENARAI)';

    protected static ?string $navigationLabel = 'DOKUMEN RUJUKAN (SENARAI)';

    protected static ?string $navigationGroup = 'TUGASAN';

    protected static ?string $slug = 'senaraipenggunadokumenrujukan';


    public static function form(Form $form): Form
    {
        $jenis_pengguna = Auth::user()->jenis_pengguna;
        $email = Auth::user()->email;
        $no_institusi_jabatan = Auth::user()->no_institusi_jabatan;

        return $form
            ->schema([
                Select::make('no_dokumen_rujukan')
                    ->label('No. Dokumen')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options(DokumenRujukan::where('aktif', '1')->where('jenis_dokumen_rujukan', 5)->pluck('nama', 'no'))
                    ->searchable()
                    ->rules('required')
                    ->live(),
                Select::make('email')
                    ->label('Senarai Pengguna')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options(function () use ($jenis_pengguna, $no_institusi_jabatan) {
                        // Eager load related models
            
                        $pengguna = Pengguna::with('institusiJabatan')->where('aktif', 1);

                        if ($jenis_pengguna == 2) {
                            // Modify the query to include a where clause for jenis_pengguna = 2
                            $pengguna->where('no_institusi_jabatan', $no_institusi_jabatan);
                        } else if ($jenis_pengguna == 4) {
                            $institusi_jabatan = InstitusiJabatan::where('no', $no_institusi_jabatan)->first();
                            $institusi = $institusi_jabatan->no_institusi;
                            $pengguna->whereHas('institusiJabatan', function ($query) use ($institusi) {
                                $query->where('no_institusi', $institusi);
                            });
                        }

                        $pengguna = $pengguna->orderBy('nama')->get();

                        // Manipulate data to format as needed for select dropdown
                        return $pengguna->mapWithKeys(function ($pengguna) {
                            return [$pengguna->email => $pengguna->nama];
                        });
                    })
                    ->searchable()
                    ->rules('required'),
                Select::make('no_jawatan')
                    ->label('Jawatan')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options(Jawatan::where('aktif', 1)->pluck('nama', 'no'))
                    ->searchable()
                    ->rules('required'),
                Select::make('no_institusi')
                    ->label('Institusi & Jabatan')
                    ->placeholder('Sila Pilih Maklumat')
                    ->searchable()
                    ->rules('required')
                    ->options(function () {
                        // Eager load related models
                        $institusi_jabatan_query = InstitusiJabatan::with('institusi', 'jabatan')->where('aktif', 1);

                        // Get the current user's institusi_jabatan
                        $user = Auth::user();


                        // Apply conditions based on jenis_pengguna
                        if ($user->jenis_pengguna == 2) {
                            $institusi_jabatan_query->where('no', $user->no_institusi_jabatan);
                        } elseif ($user->jenis_pengguna == 4) {
                            $institusi_jabatan_individu = InstitusiJabatan::where('no', $user->no_institusi_jabatan)->first();
                            $institusi = $institusi_jabatan_individu->no_institusi;
                            $institusi_jabatan_query->whereHas('institusi', function ($query) use ($institusi) {
                                $query->where('no', $institusi)->orderBy('nama');
                            });
                        }

                        // Execute the query and order the results
                        $institusi_jabatan = $institusi_jabatan_query->get();

                        // Manipulate data to format as needed for select dropdown
                        return $institusi_jabatan->mapWithKeys(function ($institusi_jabatan) {
                            return [$institusi_jabatan->no => $institusi_jabatan->institusi->nama . ' - ' . $institusi_jabatan->jabatan->nama];
                        });
                    }),
                Forms\Components\TextInput::make('kedudukan')->label('Kedudukan')->integer()->rules('required'),
                Select::make('aktif')
                    ->placeholder('Sila Pilih Maklumat')
                    ->options([
                        '1' => 'AKTIF',
                        '0' => 'TIDAK AKTIF',
                    ])
                    ->rules('required'),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('dokumenrujukan.nama')->label('No. Dokumen'),
                Tables\Columns\TextColumn::make('pengguna.nama')->label('Nama'),
                Tables\Columns\TextColumn::make('gred.nama')->label('Jawatan'),
                Tables\Columns\TextColumn::make('kedudukan')->label('kedudukan'),
                TextColumn::make('dokumenrujukan.nama')->label('No. Dokumen')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('pengguna.nama')->label('NAMA')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('gred.nama')->label('JAWATAN')->searchable(isIndividual: true, isGlobal: false),
                TextColumn::make('kedudukan')->label('KEDUDUKAN')->searchable(isIndividual: true, isGlobal: false),
            ])
            ->deferLoading()
            ->striped()
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make()->label(''),
                Tables\Actions\DeleteAction::make()->label(''),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSenaraiPenggunaDokumenRujukans::route('/'),
            'create' => Pages\CreateSenaraiPenggunaDokumenRujukan::route('/create'),
            'edit' => Pages\EditSenaraiPenggunaDokumenRujukan::route('/{record}/edit'),
        ];
    }

    public static function canViewAny(): bool
    {
        $userId = auth()->user()->jenis_pengguna;
        return in_array($userId, [1, 4]);
    }
}
